const puppeteer = require('puppeteer');
const {
    generateRandomUA,
    wait
} = require('../utils/browserUtils');
const {
    normalizeURL
} = require('../utils/urlUtils');
const proxyChain = require('proxy-chain');
const {
    getProxy,
    updateProxyUsage,
    resetProxyStatus
} = require('../proxy/database');

// Fungsi untuk langsung mengunjungi URL target tanpa pencarian
const visitTargetDirectly = async (targetURL) => {
    while (true) {
        const selectedProxy = await getProxy();

        if (!selectedProxy) {
            console.log('Tidak ada proxy yang tersedia. Menghentikan proses...');
            process.exit(0);
        }

        let proxyChainUrl;
        let proxyUrl;
        if (selectedProxy.proxyAddress.startsWith('socks5://') || selectedProxy.proxyAddress.startsWith('socks4://')) {
            // Jika proxy menggunakan socks5 atau socks4, gunakan langsung address-nya
            proxyChainUrl = selectedProxy.proxyAddress;
        } else if (selectedProxy.proxyAuth) {
            // Jika tidak, anonymize proxy menggunakan proxyChain dan proxyAuth jika ada
            proxyUrl = `http://${selectedProxy.proxyAuth}@${selectedProxy.proxyAddress}`;
            proxyChainUrl = await proxyChain.anonymizeProxy(proxyUrl);
        } else {
            proxyUrl = `http://${selectedProxy.proxyAddress}`;
            proxyChainUrl = await proxyChain.anonymizeProxy(proxyUrl)
        }

        const launchOptions = {
            headless: false,
            slowMo: 50,
            args: [`--proxy-server=${proxyChainUrl}`]
        };

        console.log(`Menggunakan proxy: ${proxyUrl}`);
        const browser = await puppeteer.launch(launchOptions);
        try {
            const page = await browser.newPage();
            const randomUserAgent = generateRandomUA();
            await page.setUserAgent(randomUserAgent);
            await page.setViewport({
                width: 375,
                height: 667
            });

            // Normalisasi URL target sebelum digunakan
            let normalizedTargetURL = normalizeURL(`https://${targetURL.replace(/^(https?:\/\/)?/, '')}`);
            console.log(`Mengunjungi: ${normalizedTargetURL}`);
            await page.goto(normalizedTargetURL, {
                waitUntil: 'networkidle2',
                timeout: 60000
            });

            await wait(8000);

            await page.evaluate(() => {
                window.scrollTo({
                    top: document.body.scrollHeight,
                    behavior: 'smooth'
                });
            });
            await wait(3000);

            await page.evaluate(() => {
                window.scrollTo({
                    top: 0,
                    behavior: 'smooth'
                });
            });

            let foundMatch = false;
            const status = "";
            // Menutup Banner
            const elementHidden = await page.evaluate(() => {
                const banner = document.getElementById('PopupBanner');
                if (banner) {
                    banner.style.display = 'none';
                    banner.classList.remove('show');
                    return true;
                }
                return false;
            });

            if (elementHidden) {
                console.log('Banner berhasil disembunyikan.');
                console.log('Menunggu 3 menit di halaman target...');
                await wait(180000); // Tunggu 3 menit di halaman target

                // Memunculkan Navbar
                const sideNav = await page.evaluate(() => {
                    const navbar = document.getElementById('side_nav');
                    const overlay = document.getElementById('sidenav_overlay');
                    if (navbar) {
                        if (overlay) {
                            navbar.classList.add('side-show');
                            overlay.classList.add('sidenav-overlay');
                            return true;
                        }
                    }
                    return false;
                });

                if (sideNav) {
                    console.log('Navbar berhasil dimunculkan.');
                    await wait(3000);
                    // Mencari link dengan kata "Serverajaib" dan klik link tersebut
                    const linkClicked = await page.evaluate(() => {
                        const link = Array.from(document.querySelectorAll('a')).find(a =>
                            a.innerText.toLowerCase().includes('Serverajaib'));
                        if (link) {
                            link.click();
                            return true;
                        }
                        return false;
                    });

                    if (linkClicked) {
                        console.log('Link dengan kata "Serverajaib" berhasil diklik.');
                        await wait(180000); // Tunggu 3 menit di halaman target
                        foundMatch = true;
                    } else {
                        console.log('Link dengan kata "Serverajaib" tidak ditemukan.');
                    }
                } else {
                    console.log('Navbar tidak ditemukan.');
                }
            } else {
                console.log('Mencoba mencari Link "Serverajaib" ...');
                await wait(3000);
                // Mencari link dengan kata "Serverajaib" dan klik link tersebut
                const linkClicked = await page.evaluate(() => {
                    const link = Array.from(document.querySelectorAll('a')).find(a =>
                        a.innerText.toLowerCase().includes('Serverajaib'));
                    if (link) {
                        link.click();
                        return true;
                    }
                    return false;
                });

                if (linkClicked) {
                    console.log('Link dengan kata "Serverajaib" berhasil diklik.');

                    // Tunggu beberapa detik untuk memastikan halaman termuat sepenuhnya
                    await wait(5000);

                    // Memeriksa apakah halaman berisi kata "CloudFlare"
                    const containsCloudFlare = await page.evaluate(() => {
                        return document.body.innerText.includes('Cloudflare'); // Memeriksa teks halaman
                    });

                    if (containsCloudFlare) {
                        console.log('Link dengan kata "Serverajaib" ditemukan, tetapi gagal mengunjungi.');
                    } else {
                        console.log('Berhasil mengunjungi, menunggu 3 menit...');
                        await wait(Math.floor(Math.random() * 5000) + 5000);

                        await page.evaluate(() => {
                            window.scrollTo({
                                top: document.body.scrollHeight,
                                behavior: 'smooth'
                            });
                        });

                        await wait(3000);

                        await page.evaluate(() => {
                            window.scrollTo({
                                top: 0,
                                behavior: 'smooth'
                            });
                        });
                        await wait(180000); // Tunggu 3 menit di halaman target
                        foundMatch = true;
                    }
                } else {
                    console.log('Link dengan kata "Serverajaib" tidak ditemukan.');
                }
            }

            if (foundMatch) {
                console.log(`Berhasil mengunjungi ${normalizedTargetURL}`);
                status = 'success';
            } else {
                console.log(`Gagal mengunjungi ${normalizedTargetURL}`);
                status = 'failed';
            }

            updateProxyUsage(selectedProxy.id, status);
            await browser.close();
        } catch (err) {
            console.error(`Gagal terhubung dengan proxy: ${selectedProxy.proxyAddress}`);
            const status = 'failed';
            updateProxyUsage(selectedProxy.id, status);
            await browser.close();
        } finally {
            try {
                if (browser) {
                    resetProxyStatus(selectedProxy.id);
                    console.log('Menutup browser...');
                    await browser.close();
                    console.log('Browser berhasil ditutup.');
                }
            } catch (closeErr) {
                console.error('Gagal menutup browser:', closeErr);
            }
        }
    }
};

module.exports = {
    visitTargetDirectly
};