const puppeteer = require('puppeteer');
const proxyChain = require('proxy-chain');
const { generateRandomUA, wait, autoScroll } = require('../utils/browserUtils');
const { normalizeURL } = require('../utils/urlUtils');
const { getProxy, updateProxyUsage, resetProxyStatus } = require('../proxy/database');

// Fungsi untuk perilaku acak setelah menunggu di website
const performRandomPostVisitAction = async (page) => {
    try {
        console.log('Melakukan auto-scroll...');
        await autoScroll(page);

        // Tunggu durasi acak antara 20 detik hingga 3 menit
        const randomWaitTime = Math.floor(Math.random() * (180000 - 20000 + 1)) + 20000;
        console.log(`Menunggu selama ${randomWaitTime / 1000} detik sebelum menjalankan perilaku acak...`);
        await wait(randomWaitTime);

        // Daftar aksi dengan selector CSS
        // const actions = [
        //     { selector: 'a.register-button', action: 'Klik tombol "Daftar"' },
        //     { selector: 'a.login-button', action: 'Klik tombol "Masuk"' },
        //     { selector: 'a[href="https://www.appptma.org/"]', action: 'Klik link "MANTAP168"' }
        // ];

        // Deteksi apakah halaman adalah AMP
        const isAMP = await page.evaluate(() => {
            return document.documentElement.hasAttribute('amp') || document.documentElement.hasAttribute('⚡');
        });

        if (isAMP) {
            console.log('Halaman AMP terdeteksi.');

            // Jika halaman AMP, menggunakan XPath
            actions.forEach(action => {
                action.selector = `//a[@href="${action.selector.replace('a[href="', '').replace('"]', '')}"]`;
            });
        }

        // Pilih aksi acak
        const randomAction = actions[Math.floor(Math.random() * actions.length)];
        let element;

        if (isAMP) {
            // Gunakan XPath untuk mencari elemen jika halaman AMP
            const elements = await page.$x(randomAction.selector);
            element = elements.length > 0 ? elements[0] : null;
        } else {
            // Gunakan CSS selector untuk halaman non-AMP
            element = await page.$(randomAction.selector);
        }

        if (element) {
            console.log(`Melakukan klik pada ${randomAction.action}`);
            await page.waitForSelector(randomAction.selector, { visible: true, timeout: 5000 });
            await element.click();
        } else {
            console.log(`Tidak ditemukan elemen untuk ${randomAction.action}`);
        }

        console.log('Prilaku acak selesai.');
    } catch (error) {
        console.error('Error saat melakukan prilaku acak:', error);
    }
};

// Fungsi untuk mencari dan mengunjungi website target
const searchAndVisitTarget = async (keyword, targetURL) => {
    while (true) {
        const selectedProxy = await getProxy();

        if (!selectedProxy) {
            console.log('Tidak ada proxy yang tersedia. Menghentikan proses...');
            process.exit(0);
        }

        let proxyChainUrl;
        let proxyUrl;
        if (selectedProxy.proxyAddress.startsWith('socks5://') || selectedProxy.proxyAddress.startsWith('socks4://')) {
            proxyChainUrl = selectedProxy.proxyAddress;
        } else if (selectedProxy.proxyAuth) {
            proxyUrl = `http://${selectedProxy.proxyAuth}@${selectedProxy.proxyAddress}`;
            proxyChainUrl = await proxyChain.anonymizeProxy(proxyUrl);
        } else {
            proxyUrl = `http://${selectedProxy.proxyAddress}`;
            proxyChainUrl = await proxyChain.anonymizeProxy(proxyUrl);
        }

        const launchOptions = {
            headless: false,
            slowMo: 50,
            args: [`--proxy-server=${proxyChainUrl}`]
        };

        console.log(`Menggunakan proxy: ${proxyUrl}`);
        const browser = await puppeteer.launch(launchOptions);
        try {
            const page = await browser.newPage();
            const randomUserAgent = generateRandomUA();
            await page.setUserAgent(randomUserAgent);
            await page.setViewport({ width: 375, height: 667 });

            let foundMatch = false;

            const searchForTarget = async (targetURL1, targetURL2) => {
                console.log(`Mencari: ${targetURL1} & ${targetURL2}`);

                await page.goto('https://www.google.com', {
                    waitUntil: 'networkidle2',
                    timeout: 60000
                });
                await page.waitForSelector('textarea[name="q"], input[name="q"]', {
                    visible: true,
                    timeout: 60000
                });

                // Jika menggunakan user agent yang mungkin memiliki perbedaan selektor, pilih selektor yang benar
                const inputSelector = await page.$('textarea[name="q"], input[name="q"]');
                if (inputSelector) {
                    await inputSelector.type(keyword, { delay: 10 });
                    await page.keyboard.press('Enter');
                } else {
                    console.log('Tidak dapat menemukan kolom pencarian.');
                    return;
                }

                let hasMoreResults = true;

                while (hasMoreResults) {
                    await page.waitForSelector('.MBeuO', { visible: true, timeout: 60000 });

                    await autoScroll(page);
                    await wait(3000);

                    const results = await page.$$('a.cz3goc');
                    let foundTarget = false;

                    for (let result of results) {
                        const a = await page.evaluate(el => el.href, result);
                        const normalizedHref = normalizeURL(a);
                        if (normalizedHref === targetURL1 || normalizedHref === targetURL2) {
                            console.log('Link cocok dengan TARGET_URL. Mengklik link...');
                            await result.click();

                            // Tunggu random dan lakukan perilaku acak setelah mengunjungi link
                            console.log('Melakukan perilaku acak setelah menunggu...');
                            await performRandomPostVisitAction(page);

                            foundMatch = true;
                            foundTarget = true;
                            break;
                        }
                    }

                    if (foundTarget) {
                        hasMoreResults = false;
                    } else {
                        const moreResultsButton = await page.$('a.T7sFge.sW9g3e.VknLRd.CqmPRe');
                        if (moreResultsButton) {
                            console.log('Mengklik tombol "More Results"...');
                            await moreResultsButton.click();
                            await wait(3000);
                        } else {
                            console.log('Tidak ada tombol "More Results" yang ditemukan. Menghentikan pencarian.');
                            hasMoreResults = false;
                        }
                    }
                }
            };

            let targetURL1 = normalizeURL(`https://www.${targetURL.replace(/^(https?:\/\/)?(www\.)?/, '')}`);
            let targetURL2 = normalizeURL(`https://${targetURL.replace(/^(https?:\/\/)?/, '')}`);

            await searchForTarget(targetURL1, targetURL2);

            const status = foundMatch ? 'success' : 'failed';

            updateProxyUsage(selectedProxy.id, status);

            if (!foundMatch) {
                console.log('Mencoba lagi dengan "http"');
                targetURL1 = targetURL1.replace('https://', 'http://');
                targetURL2 = targetURL2.replace('https://', 'http://');
                await searchForTarget(targetURL1, targetURL2);
            }

        } catch (err) {
            console.error(err);
            updateProxyUsage(selectedProxy.id, 'failed');
        } finally {
            if (browser) {
                resetProxyStatus(selectedProxy.id);
                console.log('Menutup browser...');
                await browser.close();
                console.log('Browser berhasil ditutup.');
            }
        }
    }
};

module.exports = {
    searchAndVisitTarget
};
