// Fungsi untuk menghasilkan User-Agent acak
const generateRandomUA = () => {
    const userAgents = [
        // Android User-Agents
        'Mozilla/5.0 (Linux; Android 11; SM-G998B) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/110.0.0.0 Mobile Safari/537.36',
        'Mozilla/5.0 (Linux; Android 10; SM-G975F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Mobile Safari/537.36',
        'Mozilla/5.0 (Linux; Android 9; Pixel 3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/108.0.0.0 Mobile Safari/537.36',
        'Mozilla/5.0 (Linux; Android 11; SM-G991B) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/110.0.0.0 Mobile Safari/537.36',
        'Mozilla/5.0 (Linux; Android 10; SM-A515F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/108.0.0.0 Mobile Safari/537.36',
        
        // iPhone User-Agents
        'Mozilla/5.0 (iPhone; CPU iPhone OS 14_0 like Mac OS X) AppleWebKit/537.36 (KHTML, like Gecko) Version/14.0 Mobile/15E148 Safari/537.36',
        'Mozilla/5.0 (iPhone; CPU iPhone OS 13_4 like Mac OS X) AppleWebKit/537.36 (KHTML, like Gecko) Version/13.4 Mobile/15E148 Safari/537.36',
        'Mozilla/5.0 (iPhone; CPU iPhone OS 12_3 like Mac OS X) AppleWebKit/537.36 (KHTML, like Gecko) Version/12.3 Mobile/15E148 Safari/537.36',
        'Mozilla/5.0 (iPhone; CPU iPhone OS 11_4_1 like Mac OS X) AppleWebKit/537.36 (KHTML, like Gecko) Version/11.4.1 Mobile/15E148 Safari/537.36',
        'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_3 like Mac OS X) AppleWebKit/537.36 (KHTML, like Gecko) Version/10.3.3 Mobile/15E148 Safari/537.36'
    ];

    const randomUAIndex = Math.floor(Math.random() * userAgents.length);
    return userAgents[randomUAIndex]; // Mengembalikan User-Agent yang terpilih secara acak
};

// Fungsi untuk menunggu selama waktu tertentu (dalam milidetik)
const wait = (ms) => new Promise(resolve => setTimeout(resolve, ms));

// Fungsi untuk melakukan auto-scroll dengan deteksi AMP (Accelerated Mobile Pages)
async function autoScroll(page) {
    // Menentukan jarak acak untuk scroll (antara 100px hingga 200px)
    const distance = Math.floor(Math.random() * (200 - 100 + 1)) + 100;
    // Interval waktu acak antara 100ms dan 300ms
    const interval = Math.floor(Math.random() * (300 - 100 + 1)) + 100;

    try {
        // Mengeksekusi skrip untuk halaman web
        await page.evaluate(async (distance, interval) => {
            // Deteksi apakah halaman menggunakan AMP (Accelerated Mobile Pages)
            const isAMP = document.documentElement.hasAttribute('amp') || document.documentElement.hasAttribute('⚡');
            console.log(`Halaman AMP: ${isAMP}`);

            // Melakukan scroll hingga mencapai bagian bawah halaman
            await new Promise((resolve) => {
                let totalHeight = 0;
                let timer = setInterval(() => {
                    const scrollHeight = document.body.scrollHeight;

                    // Jika halaman AMP, gunakan elemen AMP untuk melakukan scroll
                    if (isAMP) {
                        const ampScrollable = document.querySelector('amp-story, amp-body') || document.documentElement;
                        ampScrollable.scrollBy(0, distance);
                    } else {
                        // Jika halaman bukan AMP, lakukan scroll biasa
                        window.scrollBy(0, distance);
                    }

                    totalHeight += distance;

                    // Jika sudah mencapai bagian bawah halaman, hentikan scroll
                    if (totalHeight >= scrollHeight - window.innerHeight) {
                        clearInterval(timer);
                        console.log('Scroll selesai');
                        resolve();
                    }
                }, interval);
            });
        }, distance, interval);
    } catch (error) {
        console.error('Error saat melakukan auto-scroll:', error);
    }
}

module.exports = {
    generateRandomUA,
    wait,
    autoScroll
};
