const normalizeURL = (url) => {
    try {
        const parsedUrl = new URL(url);
        return `${parsedUrl.protocol}//${parsedUrl.hostname}${parsedUrl.pathname}`;
    } catch (e) {
        console.error('Error normalizing URL:', e);
        return url;
    }
}

module.exports = {
    normalizeURL
};