const readline = require('readline');
const {
    searchAndVisitTarget
} = require('./main/searchAndVisit');
const {
    resetStartAndEndTime
} = require('./proxy/database');
const {
    visitTargetDirectly
} = require('./main/direct');
const {
    pushProxy
} = require('./proxy/pushProxy');
const {
    summary
} = require('./main/summary');
const {
    runEveryTenMinutes
} = require('./proxy/scrap');
const {
    wait
} = require('./utils/browserUtils');

// Buat interface untuk mengambil input dari console
const rl = readline.createInterface({
    input: process.stdin,
    output: process.stdout
});

// Fungsi untuk menjalankan searchAndVisitTarget dengan jumlah browser yang ditentukan
const executeSearchAndVisit = async (keyword, TARGET_URL, browserCount) => {
    resetStartAndEndTime();
    const tasks = [];
    for (let i = 0; i < browserCount; i++) {
        await wait(1000);
        tasks.push(searchAndVisitTarget(keyword, TARGET_URL));
    }
    await Promise.all(tasks);
};

// Fungsi untuk menjalankan visitTargetDirectly dengan jumlah browser yang ditentukan
const executeDirectVisit = async (TARGET_URL, browserCount) => {
    resetStartAndEndTime();
    const tasks = [];
    for (let i = 0; i < browserCount; i++) {
        await wait(1000);
        tasks.push(visitTargetDirectly(TARGET_URL));
    }
    await Promise.all(tasks);
};

// Ambil input dari console
const startProgram = () => {
    rl.question('Pilih menu:\n1. Cari dari Google\n2. Direct Langsung\n3. Input Proxy Ke Database\n4. Scrapping Proxy\n5. Rekapitulasi Proxy\nPilihan Anda: ', (menu) => {
        switch (menu) {
            case '1':
                rl.question('Masukkan URL target: ', (TARGET_URL) => {
                    rl.question('Masukkan kata kunci: ', (keyword) => {
                        rl.question('Masukkan jumlah browser yang ingin digunakan: ', (browserCount) => {
                            browserCount = parseInt(browserCount);
                            console.log(`Menjalankan ${browserCount} browser untuk pencarian Google...`);
                            executeSearchAndVisit(keyword, TARGET_URL, browserCount).then(() => {
                                console.log('Selesai menjalankan pencarian Google.');
                                rl.close();
                            });
                        });
                    });
                });
                break;

            case '2':
                rl.question('Masukkan URL target: ', (TARGET_URL) => {
                    rl.question('Masukkan jumlah browser yang ingin digunakan: ', (browserCount) => {
                        browserCount = parseInt(browserCount);
                        console.log(`Menjalankan ${browserCount} browser untuk direct visit...`);
                        executeDirectVisit(TARGET_URL, browserCount).then(() => {
                            console.log('Selesai menjalankan direct visit.');
                            rl.close();
                        });
                    });
                });
                break;

            case '3':
                console.log('Menjalankan input proxy ke database...');
                pushProxy();
                break;

            case '4':
                console.log('Menjalankan scraping proxy...');
                runEveryTenMinutes();
                break;

            case '5':
                console.log('Membuat Rekapitulasi Proxy...');
                summary().then(() => {
                    console.log('Selesai membuat rekapitulasi proxy.');
                    rl.close();
                });
                break;

            default:
                console.log('Pilihan tidak valid. Silakan coba lagi.');
                rl.close();
                break;
        }
    });

};

// Jalankan program
startProgram();

// Tangani sinyal CTRL+C
// process.on('SIGINT', () => {
//     try {
//         updateEndTime(); // Tunggu sampai query selesai
//         console.log('Menghentikan proses...');
//         process.exit(); // Setelah query selesai, keluar dari proses
//     } catch (error) {
//         console.error('Error saat memperbarui waktu end:', error);
//         process.exit(1); // Keluar dengan kode kesalahan jika ada error
//     }
// });

// // Tangani proses keluar normal
// process.on('exit', (code) => {
//     try {
//         updateEndTime(); // Tunggu sampai query selesai
//         console.log(`Proses keluar dengan kode: ${code}`);
//     } catch (error) {
//         console.error('Error saat memperbarui waktu end:', error);
//     }
// });