const puppeteer = require('puppeteer');
const fs = require('fs');

// Fungsi utama untuk scraping proxy
const scrapeProxies = async () => {
    try {

        const browser = await puppeteer.launch({
            headless: true
        });
        const page = await browser.newPage();

        await page.goto('https://www.sslproxies.org/');

        // Klik ikon clipboard (<i class="fa fa-clipboard"></i>)
        await page.click('i.fa.fa-clipboard');


        await new Promise(resolve => setTimeout(resolve, 1000));


        const proxyList = await page.evaluate(() => {
            const textarea = document.querySelector('textarea.form-control');
            return textarea ? textarea.value : '';
        });


        console.log('Proxy yang diambil:', proxyList);


        const filePath = 'proxyscrap.txt';
        if (proxyList) {
            fs.writeFileSync(filePath, proxyList);
            console.log(`Proxy berhasil disimpan ke ${filePath}`);
        } else {
            console.log('Tidak ada proxy yang ditemukan.');
        }


        await browser.close();
    } catch (error) {
        console.error('Error saat scraping proxies:', error);
    }
};

const runEveryTenMinutes = () => {

    scrapeProxies();


    const intervalId = setInterval(scrapeProxies, 600000);


    setTimeout(() => {
        clearInterval(intervalId);
        console.log('Selesai menjalankan skrip selama 24 jam.');
    }, 86400000);
};


module.exports = {
    runEveryTenMinutes
};